var bcrypt = require('bcrypt-nodejs');
var jwt = require('jsonwebtoken');

module.exports = {
  secret: sails.config.jwtSettings.secret,
  issuer: sails.config.jwtSettings.issuer,
  audience: sails.config.jwtSettings.audience,

  /**
   * Transforma a senha passada pela requisição em HASH
   */
  hashPassword: function (user) {
    if (user.password) {
      user.password = bcrypt.hashSync(user.password);
    }
  },

  /**
   * Compara a senha do usuário no banco com a senha em HASH
   * @returns boolean indicando sucesso ou falha
   */
  comparePassword: function (password, user) {
    return bcrypt.compareSync(password, user.password);
  },

  /**
   * Gero o token a partir do usuário passado
   * @param user
   */
  createToken: function (user, listPermissions = null) {

    //sails.log(user);

    return jwt.sign({
      user: { id: user.id, email: user.email },
      listPermissions: listPermissions
    },
      sails.config.jwtSettings.secret,
      {
        algorithm: sails.config.jwtSettings.algorithm,
        expiresIn: sails.config.jwtSettings.expiresInMinutes,
        issuer: sails.config.jwtSettings.issuer,
        audience: sails.config.jwtSettings.audience
      }
    );
  },





};