var passport = require('passport');
var LocalStrategy = require('passport-local').Strategy;
var JwtStrategy = require('passport-jwt').Strategy,
    ExtractJwt = require('passport-jwt').ExtractJwt;
var bcrypt = require('bcrypt-nodejs');

var EXPIRES_IN_MINUTES = 2 * 60 * 60; // duas horas
var SECRET = process.env.tokenSecret || "4ukI0uIVnB3iI1yxj646fVXSE3ZVk4doZgz6fTbNg7jO41EAtl20J5F7Trtwe7OM";
var ALGORITHM = "HS256";
var ISSUER = "tolentinos.com.br";
var AUDIENCE = "tolentinos.com.br";

//Serializar Usuário

passport.serializeUser(function (user, cb) {
    cb(null, user.id);
});

//Deserializar Usuário

passport.deserializeUser(function (id, cb) {
    User.findOne({ id }).exec(function (err, user) {
        cb(err, user);
    });
})


//Configuration object for JWT strategy

var JWT_STRATEGY_CONFIG = {
    jwtFromRequest: ExtractJwt.fromAuthHeaderAsBearerToken(),
    secretOrKey: SECRET,
    issuer: ISSUER,
    audience: AUDIENCE,
    passReqToCallback: false
};

var LOCAL_STRATEGY_CONFIG = {
    usernameField: 'email',
    passwordField: 'password',
    passReqToCallback: false
}

/* Trigga ao autenticar o usuário via LocalStrategy */
function _onLocalStrategyAuth(email, password, cb) {
    User.findOne({ email: email}).exec(function (err, user) {
        if (err) return cb(err);
        if (!user) return cb(null, false, { message: 'Nome de usuário não encontrado!' });

        bcrypt.compare(password, user.password, function (err, res) {
            if (!res) return cb(null, false, { message: 'Senha inválida!' });
            return cb(null, user, { message: 'Login Sucesso!' });
        })
    });
}

/* Trigga ao autenticar o usuário via JWT (Token) */
function _onJwtStrategyAuth(payload, next) {
    var user = payload.user;
    return next(null, user, {});
}

//Local
passport.use(new LocalStrategy(LOCAL_STRATEGY_CONFIG, _onLocalStrategyAuth));

//JWT
passport.use(new JwtStrategy(JWT_STRATEGY_CONFIG, _onJwtStrategyAuth));

module.exports.jwtSettings = {
    expiresInMinutes: EXPIRES_IN_MINUTES,
    secret: SECRET,
    algorithm: ALGORITHM,
    issuer: ISSUER,
    audience: AUDIENCE
}