var passport = require('passport');
var passportService = require('../services/passport')
var permissionService = require('../services/permission-validate');

module.exports = function (req, res, next) {

    sails.log('Received HTTP request: ' + req.method + ' ' + req.path);

    passport.authenticate('jwt', async function (err, user, info) {

        if (err) return res.serverError(err);
        if (!user)
            return res.forbidden(null, info && info.code, info && info.message);

        //Verificar se tem permissão de acessar a rota
        let canAcess = JSON.parse(await permissionService.canPermissionToAcessRoute(user, req.method, req.path));


        if (canAcess.status == 403) {
            sails.log(canAcess);
        } else if (canAcess.status != 200) {
            sails.log('canAcess')
            sails.log(canAcess);
           // return res.forbidden(null, info && info.code, canAcess && canAcess.message);
        } else {
            //Salvar log de acesso
            //TODO Não será implementado nesse momento
        }

        //Carregar os dados do usuário
        let userData = await User.findOne({
            where: { 'id': user.id },
            select: ['id', 'email']
        })

        //sails.log(userData);

        //Montar o dado do usuário
        let userLogged = {
            id: userData.id,
            email: userData.email,
        };

        //sails.log(userLogged);

        req.user = userLogged;
        next();
    })(req, res);
}