/**
 * FIIController
 *
 * @description :: Server-side actions for handling incoming requests.
 * @help        :: See https://sailsjs.com/docs/concepts/actions
 */
const crawlerService = require('../services/crawler')

module.exports = {

    getAllFii: async function (req, res) {

        let rows = await FII.find()
            .sort('ticket ASC');

        return res.ok(rows);

    },

    updateFiiFundsExplorer: async function (req, res) {

        let listFii = [];

        await crawlerService.getDatafii().then(
            data => {
                listFii = data;
            }
        );

        for (const item of listFii) {
            // 
            let updatedRecord = await FII.updateOne({ ticket: item.ticket }).set(item);
            if (updatedRecord) {
                console.log("Atualizado: " + item.ticket)
            } else {
                let data = await FII.create(item).fetch();
                if (data) {
                    console.log("Criado: " + item.ticket);
                } else {
                    console.log("ERRO: " + JSON.stringify(item));
                }
            }
        }

        return res.ok(listFii);
    }


};

